/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.InventoryCraftingDecompress;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9694;

public class CompressMessage
implements class_8710 {
    public static class_8710.class_9154<CompressMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"craftingtweaks", (String)"compress"));
    private final int slotNumber;
    private final CompressType type;

    public CompressMessage(int slotNumber, CompressType type) {
        this.slotNumber = slotNumber;
        this.type = type;
    }

    public static CompressMessage decode(class_2540 buf) {
        int slotNumber = buf.readInt();
        CompressType type = CompressType.values()[buf.readByte()];
        return new CompressMessage(slotNumber, type);
    }

    public static void encode(class_2540 buf, CompressMessage message) {
        buf.method_53002(message.slotNumber);
        buf.method_52997(message.type.ordinal());
    }

    public static void handle(class_3222 player, CompressMessage message) {
        if (player == null) {
            return;
        }
        class_1703 menu = player.field_7512;
        if (menu == null) {
            return;
        }
        CompressType compressType = message.type;
        class_1735 mouseSlot = (class_1735)menu.field_7761.get(message.slotNumber);
        if (!(mouseSlot.field_7871 instanceof class_1661)) {
            return;
        }
        class_1799 mouseStack = mouseSlot.method_7677().method_7972();
        if (mouseStack.method_7960()) {
            return;
        }
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        boolean compressRequiresCraftingGrid = CraftingTweaksConfig.getActive().common.compressRequiresCraftingGrid;
        if (compressRequiresCraftingGrid && grid == null) {
            return;
        }
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_STACK || compressType == CompressType.DECOMPRESS_ONE) {
            boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
            block5: for (class_1735 slot : menu.field_7761) {
                int suitableSlot;
                class_1799 result;
                if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot) continue;
                class_1799 slotStack = slot.method_7677();
                if (!(slot.field_7871 instanceof class_1661) || !class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)mouseStack)) continue;
                InventoryCraftingDecompress craftingContainer = new InventoryCraftingDecompress(menu, slotStack);
                if (slotStack.method_7960() || slotStack.method_7947() < 1) continue;
                while (!(result = CompressMessage.assembleResult(craftingContainer.method_59961(), craftingContainer, player)).method_7960() && !CompressMessage.isBlacklisted(result) && (suitableSlot = CompressMessage.getSlotWithEnoughSpaceToFit(player.method_31548(), result)) != -1) {
                    if (!player.method_31548().method_7394(result)) {
                        player.method_7328(result, true);
                    }
                    CompressMessage.giveLeftoverItems(player, slotStack, 1);
                    slot.method_7671(1);
                    if (decompressAll && slot.method_7681() && slotStack.method_7947() >= 1 && class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)mouseStack)) continue;
                    continue block5;
                }
            }
        } else {
            switch (compressType) {
                case COMPRESS_ONE: {
                    CompressMessage.compressMouseSlot(player, menu, mouseSlot, grid, compressRequiresCraftingGrid, false);
                    break;
                }
                case COMPRESS_STACK: {
                    CompressMessage.compressMouseSlot(player, menu, mouseSlot, grid, compressRequiresCraftingGrid, true);
                    break;
                }
                case COMPRESS_ALL: {
                    CompressMessage.compressAll(player, menu, mouseSlot, grid, compressRequiresCraftingGrid);
                }
            }
        }
        menu.method_7623();
    }

    private static int getSlotWithEnoughSpaceToFit(class_1661 inventory, class_1799 result) {
        int firstEmptySlot = -1;
        for (int slot = 0; slot < 36; ++slot) {
            class_1799 slotStack = inventory.method_5438(slot);
            if (slotStack.method_7960() && firstEmptySlot == -1) {
                firstEmptySlot = slot;
                continue;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)result) || !slotStack.method_7946() || slotStack.method_7947() + result.method_7947() > inventory.method_58350(slotStack)) continue;
            return slot;
        }
        return firstEmptySlot;
    }

    private static void compressMouseSlot(class_3222 player, class_1703 menu, class_1735 mouseSlot, CraftingGrid grid, boolean compressRequiresCraftingGrid, boolean wholeStack) {
        int maxGridSize = grid != null && compressRequiresCraftingGrid ? grid.getGridSize((class_1657)player, menu) : 9;
        class_1799 mouseStack = mouseSlot.method_7677();
        CompressionRecipe recipe = CompressMessage.findRecipe(menu, player, mouseStack, maxGridSize);
        int recipeSize = recipe.size();
        if (recipeSize > 0) {
            int maxStackSize = recipe.result().method_7914();
            int craftsPossible = Math.min(mouseStack.method_7947() / recipeSize, wholeStack ? maxStackSize : 1);
            if (craftsPossible == 0) {
                return;
            }
            int itemsToRemove = craftsPossible * recipeSize;
            CompressMessage.giveLeftoverItems(player, mouseStack, itemsToRemove);
            mouseStack.method_7934(itemsToRemove);
            CompressMessage.addCraftedItemsToInventory(player, recipe.result(), craftsPossible);
        }
    }

    private static void compressAll(class_3222 player, class_1703 menu, class_1735 mouseSlot, CraftingGrid grid, boolean compressRequiresCraftingGrid) {
        int maxGridSize = grid != null && compressRequiresCraftingGrid ? grid.getGridSize((class_1657)player, menu) : 9;
        class_1799 mouseStack = mouseSlot.method_7677().method_7972();
        int totalItemCount = CompressMessage.countTotalItems(menu, mouseStack);
        CompressionRecipe recipe = CompressMessage.findRecipe(menu, player, mouseStack, maxGridSize);
        int recipeSize = recipe.size();
        if (recipeSize > 0) {
            int craftsPossible = totalItemCount / recipeSize;
            int itemsToRemove = craftsPossible * recipeSize;
            CompressMessage.removeSourceItems(player, menu, mouseStack, itemsToRemove);
            CompressMessage.addCraftedItemsToInventory(player, recipe.result(), craftsPossible);
        }
    }

    private static void giveLeftoverItems(class_3222 player, class_1799 slotStack, int count) {
        for (int i = 0; i < count; ++i) {
            class_1542 itemEntity;
            class_1799 containerItem = Balm.getHooks().getCraftingRemainingItem(slotStack);
            if (player.method_7270(containerItem) || (itemEntity = player.method_7328(containerItem, false)) == null) continue;
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
        }
    }

    private static <T extends class_9694> class_1799 assembleResult(T recipeInput, class_1732 recipeCraftingHolder, class_3222 player) {
        class_1937 level;
        class_1863 recipeManager = Objects.requireNonNull(player.method_5682()).method_3772();
        class_8786 recipe = recipeManager.method_8132(class_3956.field_17545, recipeInput, level = player.method_37908()).orElse(null);
        if (recipe != null && recipeCraftingHolder.method_7665(level, player, recipe)) {
            return ((class_3955)recipe.comp_1933()).method_8116(recipeInput, (class_7225.class_7874)level.method_30349());
        }
        return class_1799.field_8037;
    }

    private static boolean isBlacklisted(class_1799 result) {
        class_2960 registryName = class_7923.field_41178.method_10221((Object)result.method_7909());
        return CraftingTweaksConfig.getActive().common.compressDenylist.contains(registryName.toString());
    }

    private static int countTotalItems(class_1703 menu, class_1799 sourceItem) {
        int totalItemCount = 0;
        for (class_1735 slot : menu.field_7761) {
            class_1799 slotStack = slot.method_7677();
            if (!(slot.field_7871 instanceof class_1661) || !class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)sourceItem)) continue;
            totalItemCount += slotStack.method_7947();
        }
        return totalItemCount;
    }

    private static CompressionRecipe findRecipe(class_1703 menu, class_3222 player, class_1799 exampleStack, int maxGridSize) {
        InventoryCraftingCompress exampleInventory;
        int recipeSize = 0;
        class_1799 result = class_1799.field_8037;
        if (maxGridSize >= 9 && !(result = CompressMessage.assembleResult((exampleInventory = new InventoryCraftingCompress(menu, 3, exampleStack)).method_59961(), exampleInventory, player)).method_7960() && !CompressMessage.isBlacklisted(result)) {
            recipeSize = 9;
        }
        if (recipeSize == 0 && maxGridSize >= 4 && !(result = CompressMessage.assembleResult((exampleInventory = new InventoryCraftingCompress(menu, 2, exampleStack)).method_59961(), exampleInventory, player)).method_7960() && !CompressMessage.isBlacklisted(result)) {
            recipeSize = 4;
        }
        return new CompressionRecipe(recipeSize, result);
    }

    private static void removeSourceItems(class_3222 player, class_1703 menu, class_1799 sourceItem, int itemsToRemove) {
        for (class_1735 slot : menu.field_7761) {
            class_1799 slotStack = slot.method_7677();
            if (!(slot.field_7871 instanceof class_1661) || !class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)sourceItem)) continue;
            int removedFromSlot = Math.min(slotStack.method_7947(), itemsToRemove);
            CompressMessage.giveLeftoverItems(player, slotStack, removedFromSlot);
            slot.method_7671(removedFromSlot);
            if ((itemsToRemove -= removedFromSlot) != 0) continue;
            break;
        }
    }

    private static void addCraftedItemsToInventory(class_3222 player, class_1799 result, int timesCrafted) {
        class_1799 craftedStack;
        for (int itemsCrafted = timesCrafted * result.method_7947(); itemsCrafted > 0; itemsCrafted -= craftedStack.method_7947()) {
            craftedStack = result.method_7972();
            craftedStack.method_7939(Math.min(itemsCrafted, result.method_7914()));
            if (player.method_31548().method_7394(craftedStack)) continue;
            player.method_7328(craftedStack, true);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    record CompressionRecipe(int size, class_1799 result) {
    }
}

